//------------------------------------------------------------
// Copyright Sandlot Games, 2007
// author: Michael Felice
// file: client_savequestgui.cs
// brief:
//    This saves the quest data and loads the data to and from
// a file.  This is required for saving and loading.
//------------------------------------------------------------

// saves quest information to a file
function QuestGuiSaveToFile()
{
   // save the required quest list
   slgSaveInt($QuestRequiredCount);
   %checkTemplate = QuestRequiredList.getChild(BeginQuestCheck);
   for (%index = 0; %index < $QuestRequiredCount; %index++)
   {
      // save the check information
      %check = $QuestRequiredData[%index, 0];
      slgSaveString(%check.iconOffset);
      slgSaveString(%check.iconAlpha);
      slgSaveString(%check.iconEnabled);
      slgSaveString(%check.iconDisabled);
      slgSaveString(%check.position);
      slgSaveString(%check.extent);
      slgSaveString(%check.profile);
      
      if (%check.stateUp $= %checkTemplate.stateUp) %checkStateUp = 0;
      else if (%check.stateUp $= %checkTemplate.stateFocus) %checkStateUp = 1;
      else if (%check.stateUp $= %checkTemplate.stateDown) %checkStateUp = 2;
      else if (%check.stateUp $= %checkTemplate.stateDisabled) %checkStateUp = 3;
      slgSaveInt(%checkStateUp);
      
      if (%check.stateDown $= %checkTemplate.stateUp) %checkStateDown = 0;
      else if (%check.stateDown $= %checkTemplate.stateFocus) %checkStateDown = 1;
      else if (%check.stateDown $= %checkTemplate.stateDown) %checkStateDown = 2;
      else if (%check.stateDown $= %checkTemplate.stateDisabled) %checkStateDown = 3;
      slgSaveInt(%checkStateDown);
      
      slgSaveBool(%check.selected);

      // save the title information
      %title = $QuestRequiredData[%index, 1];
      slgSaveString(%title.textUp);
      slgSaveString(%title.textDisabled);
      slgSaveString(%title.trigger);
      slgSaveString(%title.description);
      slgSaveString(%title.reward);
      slgSaveBool(%title.selected);
      slgSaveBool(%title.disabled);
      slgSaveBool(%title.input);
      
      %checkImage = %title.check;
      
      // save the command state
      %testCommand = "ShowQuest(" @ %title @ ");";
      slgSaveBool(%testCommand $= %title.command);
      
      // save additional title objects
      slgSaveBool(isObject(%title.strike));
      slgSaveBool(isObject(%title.complete));
      
      // save the task information for this quest
      %taskCount = %title.tasks;
      if (%taskCount $= "") %taskCount = 0;
      slgSaveInt(%taskCount);
      for (%taskIndex = 0; %taskIndex < %taskCount; %taskIndex++)
      {
         %briefCount = %title.tasks[%taskIndex, 0];
         slgSaveInt(%briefCount);
         slgSaveInt(%title.tasks[%taskIndex, 1]);
         slgSaveString(%title.tasks[%taskIndex, 2]);

         for (%briefIndex = 0; %briefIndex < %briefCount; %briefIndex++)
         {
            slgSaveString(%title.tasks[%taskIndex, 0, %briefIndex]);
         }
      }
   }
   
   
   
   // save the optional quest list
   slgSaveInt($QuestOptionalCount);
   %checkTemplate = QuestOptionalList.getChild(BeginQuestCheck);
   for (%index = 0; %index < $QuestOptionalCount; %index++)
   {
      // save the check information
      %check = $QuestOptionalData[%index, 0];
      slgSaveString(%check.iconOffset);
      slgSaveString(%check.iconAlpha);
      slgSaveString(%check.iconEnabled);
      slgSaveString(%check.iconDisabled);
      slgSaveString(%check.position);
      slgSaveString(%check.extent);
      slgSaveString(%check.profile);
      
      if (%check.stateUp $= %checkTemplate.stateUp) %checkStateUp = 0;
      else if (%check.stateUp $= %checkTemplate.stateFocus) %checkStateUp = 1;
      else if (%check.stateUp $= %checkTemplate.stateDown) %checkStateUp = 2;
      else if (%check.stateUp $= %checkTemplate.stateDisabled) %checkStateUp = 3;
      slgSaveInt(%checkStateUp);
      
      if (%check.stateDown $= %checkTemplate.stateUp) %checkStateDown = 0;
      else if (%check.stateDown $= %checkTemplate.stateFocus) %checkStateDown = 1;
      else if (%check.stateDown $= %checkTemplate.stateDown) %checkStateDown = 2;
      else if (%check.stateDown $= %checkTemplate.stateDisabled) %checkStateDown = 3;
      slgSaveInt(%checkStateDown);
      
      slgSaveBool(%check.selected);

      // save the title information
      %title = $QuestOptionalData[%index, 1];
      slgSaveString(%title.textUp);
      slgSaveString(%title.textDisabled);
      slgSaveString(%title.trigger);
      slgSaveString(%title.description);
      slgSaveString(%title.reward);
      slgSaveBool(%title.selected);
      slgSaveBool(%title.disabled);
      slgSaveBool(%title.input);
      
      // save the command state
      %testCommand = "ShowQuest(" @ %title @ ");";
      slgSaveBool(%testCommand $= %title.command);
      
      // save additional title objects
      slgSaveBool(isObject(%title.strike));
      slgSaveBool(isObject(%title.complete));
      
      // save the task information for this quest
      %taskCount = %title.tasks;
      if (%taskCount $= "") %taskCount = 0;
      slgSaveInt(%taskCount);
      for (%taskIndex = 0; %taskIndex < %taskCount; %taskIndex++)
      {
         %briefCount = %title.tasks[%taskIndex, 0];
         slgSaveInt(%briefCount);
         slgSaveInt(%title.tasks[%taskIndex, 1]);
         slgSaveString(%title.tasks[%taskIndex, 2]);

         for (%briefIndex = 0; %briefIndex < %briefCount; %briefIndex++)
         {
            slgSaveString(%title.tasks[%taskIndex, 0, %briefIndex]);
         }
      }
   }
}

// loads quest information from a file
function QuestGuiLoadFromFile()
{
   InitializeQuestGui();
   
   // load the required quest list
   $QuestRequiredCount = slgLoadInt();
   %checkTemplate = QuestRequiredList.getChild(BeginQuestCheck);
   %titleTemplate = QuestRequiredList.getChild(BeginQuestTitle);
   for (%index = 0; %index < $QuestRequiredCount; %index++)
   {
      // create the base check object
      %checkPos = GetRequiredCheckPosition(%index);
      %check = new SLImage()
      {
         visible = "1";
         input = "0";
         onTop = "1";
         horizSizing = "relative";
         vertSizing = "relative";
         iconOffset = slgLoadString();
         iconAlpha = slgLoadString();
         iconEnabled = slgLoadString();
         iconDisabled = slgLoadString();
         position = slgLoadString();
         extent = slgLoadString();
         profile = slgLoadString();
      };
      
      // load the check information
      %checkStateUp = slgLoadInt();
      if (%checkStateUp == 0) %check.stateUp = %checkTemplate.stateUp;
      else if (%checkStateUp == 1) %check.stateUp = %checkTemplate.stateFocus;
      else if (%checkStateUp == 2) %check.stateUp = %checkTemplate.stateDown;
      else if (%checkStateUp == 3) %check.stateUp = %checkTemplate.stateDisabled;
      
      %checkStateDown = slgLoadInt();
      if (%checkStateDown == 0) %check.stateDown = %checkTemplate.stateUp;
      else if (%checkStateDown == 1) %check.stateDown = %checkTemplate.stateFocus;
      else if (%checkStateDown == 2) %check.stateDown = %checkTemplate.stateDown;
      else if (%checkStateDown == 3) %check.stateDown = %checkTemplate.stateDisabled;
      
      %check.selected = slgLoadBool();

      // create the title object
      %titlePos = GetRequiredTitlePosition(%index);
      %title = new SLTextImage()
      {
         visible = "1";
         input = "0";
         onTop = "1";
         horizSizing = "relative";
         vertSizing = "relative";
         iconOffset = %titleTemplate.iconOffset;
         iconAlpha = %titleTemplate.iconAlpha;
         iconEnabled = %titleTemplate.iconEnabled;
         iconDisabled = %titleTemplate.iconDisabled;
         textDown = %titleText;
         stateUp = %titleTemplate.stateUp;
         stateFocus = %titleTemplate.stateFocus;
         stateDown = %titleTemplate.stateDown;
         stateDisabled = %titleTemplate.stateDisabled;
         position = %titlePos;
         extent = %titleTemplate.extent;
         profile = %titleTemplate.profile;
         textIndent = %titleTemplate.textIndent;
      };

      // load the title information
      %title.command = "ShowTrigger(" @ %title @ ");";
      %title.textUp = slgLoadString();
      %title.textDown = %title.textUp;
      %title.textDisabled = slgLoadString();
      %title.trigger = slgLoadString();
      %title.description = slgLoadString();
      %title.reward = slgLoadString();
      %title.selected = slgLoadBool();
      %title.disabled = slgLoadBool();
      %title.input = slgLoadBool();
      %title.check = %check;
      
      // load the command state
      if (slgLoadBool() == true)
      {
         %title.command = "ShowQuest(" @ %title @ ");";
      }
      else
      {
         %title.command = "ShowTrigger(" @ %title @ ");";
      }
      
      // add the check and title data
      QuestRequiredList.addGuiControl(%check);
      QuestRequiredList.addGuiControl(%title);
      $QuestRequiredData[%index, 0] = %check;
      $QuestRequiredData[%index, 1] = %title;
      
      // check if the strike through object should be created
      if (slgLoadBool() == true)
      {
         %diff = GetStrikePositionDiff();
         %xPos = getWord(%titlePos, 0) + getWord(%diff, 0);
         %yPos = getWord(%titlePos, 1) + getWord(%diff, 1);
         %title.strike = new SLImage()
         {
            visible = "1";
            input = "0";
            onTop = "1";
            horizSizing = "relative";
            vertSizing = "relative";
            stateUp = StrikeQuest.stateUp;
            position = %xPos @ " " @ %yPos;
            extent = StrikeQuest.extent;
            profile = StrikeQuest.profile;
         };
         
         QuestRequiredList.addGuiControl(%title.strike);
      }
      
      // check if the complete object should be created
      if (slgLoadBool() == true)
      {
         %diff = GetCompletePositionDiff();
         %xPos = getWord(%titlePos, 0) + getWord(%diff, 0);
         %yPos = getWord(%titlePos, 1) + getWord(%diff, 1);
         %title.complete = new SLImage()
         {
            visible = "1";
            input = "0";
            onTop = "1";
            horizSizing = "relative";
            vertSizing = "relative";
            stateUp = CompleteQuest.stateUp;
            position = %xPos @ " " @ %yPos;
            extent = CompleteQuest.extent;
            profile = CompleteQuest.profile;
         };
         
         QuestRequiredList.addGuiControl(%title.complete);
      }

      // check if this title has focus      
      if (%title.selected == true)
      {
         $QuestShowInfo = %title;
      }
      
      // load the task information for this quest
      %taskCount = slgLoadInt();
      %title.tasks = %taskCount;
      for (%taskIndex = 0; %taskIndex < %taskCount; %taskIndex++)
      {
         %briefCount = slgLoadInt();
         %title.tasks[%taskIndex, 0] = %briefCount;
         %title.tasks[%taskIndex, 1] = slgLoadInt();
         %title.tasks[%taskIndex, 2] = slgLoadString();

         for (%briefIndex = 0; %briefIndex < %briefCount; %briefIndex++)
         {
            %title.tasks[%taskIndex, 0, %briefIndex] = slgLoadString();
         }
      }
   }
   
   
   
   // load the optional quest list
   $QuestOptionalCount = slgLoadInt();
   %checkTemplate = QuestOptionalList.getChild(BeginQuestCheck);
   %titleTemplate = QuestOptionalList.getChild(BeginQuestTitle);
   for (%index = 0; %index < $QuestOptionalCount; %index++)
   {
      // create the base check object
      %checkPos = GetOptionalCheckPosition(%index);
      %check = new SLImage()
      {
         visible = "1";
         input = "0";
         onTop = "1";
         horizSizing = "relative";
         vertSizing = "relative";
         iconOffset = slgLoadString();
         iconAlpha = slgLoadString();
         iconEnabled = slgLoadString();
         iconDisabled = slgLoadString();
         position = slgLoadString();
         extent = slgLoadString();
         profile = slgLoadString();
      };
      
      // load the check information
      %checkStateUp = slgLoadInt();
      if (%checkStateUp == 0) %check.stateUp = %checkTemplate.stateUp;
      else if (%checkStateUp == 1) %check.stateUp = %checkTemplate.stateFocus;
      else if (%checkStateUp == 2) %check.stateUp = %checkTemplate.stateDown;
      else if (%checkStateUp == 3) %check.stateUp = %checkTemplate.stateDisabled;
      
      %checkStateDown = slgLoadInt();
      if (%checkStateDown == 0) %check.stateDown = %checkTemplate.stateUp;
      else if (%checkStateDown == 1) %check.stateDown = %checkTemplate.stateFocus;
      else if (%checkStateDown == 2) %check.stateDown = %checkTemplate.stateDown;
      else if (%checkStateDown == 3) %check.stateDown = %checkTemplate.stateDisabled;
      
      %check.selected = slgLoadBool();

      // create the title object
      %titlePos = GetOptionalTitlePosition(%index);
      %title = new SLTextImage()
      {
         visible = "1";
         input = "0";
         onTop = "1";
         horizSizing = "relative";
         vertSizing = "relative";
         iconOffset = %titleTemplate.iconOffset;
         iconAlpha = %titleTemplate.iconAlpha;
         iconEnabled = %titleTemplate.iconEnabled;
         iconDisabled = %titleTemplate.iconDisabled;
         textDown = %titleText;
         stateUp = %titleTemplate.stateUp;
         stateFocus = %titleTemplate.stateFocus;
         stateDown = %titleTemplate.stateDown;
         stateDisabled = %titleTemplate.stateDisabled;
         position = %titlePos;
         extent = %titleTemplate.extent;
         profile = %titleTemplate.profile;
         textIndent = %titleTemplate.textIndent;
      };

      // load the title information
      %title.command = "ShowTrigger(" @ %title @ ");";
      %title.textUp = slgLoadString();
      %title.textDown = %title.textUp;
      %title.textDisabled = slgLoadString();
      %title.trigger = slgLoadString();
      %title.description = slgLoadString();
      %title.reward = slgLoadString();
      %title.selected = slgLoadBool();
      %title.disabled = slgLoadBool();
      %title.input = slgLoadBool();
      %title.check = %check;
      
      // load the command state
      if (slgLoadBool() == true)
      {
         %title.command = "ShowQuest(" @ %title @ ");";
      }
      else
      {
         %title.command = "ShowTrigger(" @ %title @ ");";
      }
      
      // add the check and title data
      QuestOptionalList.addGuiControl(%check);
      QuestOptionalList.addGuiControl(%title);
      $QuestOptionalData[%index, 0] = %check;
      $QuestOptionalData[%index, 1] = %title;
      
      // check if the strike through object should be created
      if (slgLoadBool() == true)
      {
         %diff = GetStrikePositionDiff();
         %xPos = getWord(%titlePos, 0) + getWord(%diff, 0);
         %yPos = getWord(%titlePos, 1) + getWord(%diff, 1);
         %title.strike = new SLImage()
         {
            visible = "1";
            input = "0";
            onTop = "1";
            horizSizing = "relative";
            vertSizing = "relative";
            stateUp = StrikeQuest.stateUp;
            position = %xPos @ " " @ %yPos;
            extent = StrikeQuest.extent;
            profile = StrikeQuest.profile;
         };
         
         QuestOptionalList.addGuiControl(%title.strike);
      }
      
      // check if the complete object should be created
      if (slgLoadBool() == true)
      {
         %diff = GetCompletePositionDiff();
         %xPos = getWord(%titlePos, 0) + getWord(%diff, 0);
         %yPos = getWord(%titlePos, 1) + getWord(%diff, 1);
         %title.complete = new SLImage()
         {
            visible = "1";
            input = "0";
            onTop = "1";
            horizSizing = "relative";
            vertSizing = "relative";
            stateUp = CompleteQuest.stateUp;
            position = %xPos @ " " @ %yPos;
            extent = CompleteQuest.extent;
            profile = CompleteQuest.profile;
         };
         
         QuestOptionalList.addGuiControl(%title.complete);
      }

      // check if this title has focus      
      if (%title.selected == true)
      {
         $QuestShowInfo = %title;
      }
      
      // load the task information for this quest
      %taskCount = slgLoadInt();
      %title.tasks = %taskCount;
      for (%taskIndex = 0; %taskIndex < %taskCount; %taskIndex++)
      {
         %briefCount = slgLoadInt();
         %title.tasks[%taskIndex, 0] = %briefCount;
         %title.tasks[%taskIndex, 1] = slgLoadInt();
         %title.tasks[%taskIndex, 2] = slgLoadString();

         for (%briefIndex = 0; %briefIndex < %briefCount; %briefIndex++)
         {
            %title.tasks[%taskIndex, 0, %briefIndex] = slgLoadString();
         }
      }
   }
}

